# !/bin/csh
# a shell to produce reaction paths for CPMD transition states
# using OPTIM.2.2. Don't forget to edit the CPMD input deck to
# put in the converged points!
#
set system=C1792
# mkdir paths >& /dev/null
mkdir paths

foreach file ( ts )

mkdir paths/$file
cp $system.$file paths/$file
cp output.$file paths/$file
cp odata.$file paths/$file
cp units paths/$file
cp points.$file paths/$file
cp vector.dump.$file paths/$file/vector.dump

cd paths/$file
echo ./RESTART.1 > LATEST
echo 1 >> LATEST

# plus side

cat << EOF > odata
READVEC
STEPMIN   5
BFGSSTEP
BFGSCONV  0.0000200000
PUSHOFF   0.1
STEPMIN   10
PUSHCUT   0.00002
PARALLEL   16
CPMD      $system.$file
STEPS     1800
MODE      1
POINTS
EOF
cat points.$file >> odata

cp ../../RESTART.1.$file RESTART.1
OPTIM.2.2 > output
cp points.final points.plus
cp output output.plus
cp $system.$file.out $system.$file.out.plus
cp points points.save.plus
cp odata.new odata.plus

# minus side

rm RESTART.1
cp ../../RESTART.1.$file RESTART.1
sed -e 's/MODE      1/MODE   -1/' odata > temp1 
mv temp1 odata

OPTIM.2.2 > output
cp points.final points.minus
cp output output.minus
cp $system.$file.out $system.$file.out.minus
cp points points.save.minus
cp odata.new odata.minus

#
#  Post-processing to make pathway
#  The initial transition state geometry is 
#  present in the points.save files but the ts energy is not. The
#  first energy corresponds to the second points in
#  the points.plus/minus file. The energy is not calculated
#  for the last set of points in this file.
#

#  get points and energies for plus path and reverse them

   grep "Energy" output.plus | grep -v CPMD > temp
   sed -e '/[A-z]/s///g' -e 's/^.*=//' -e 's/\///' -e 's/^  *//' -e 's/ .*//' temp > crap
   reverse < crap > energies.plus


   set natoms=`wc -l points.minus | sed -e 's/[A-z]//g' -e 's/\.//g'`
   echo $natoms > junk8
   cat points.save.plus >> junk8
   reverse.block < junk8 > points.save.plus
   rm junk8
 
#  Now for the minus side. Delete the first points
#  so that the transition state isn't duplicated.

   grep "Energy" output.$file | tail -1 > temp
   grep "Energy" output.minus | grep -v CPMD >> temp
   sed -e '/[A-z]/s///g' -e 's/^.*=//' -e 's/\///' -e 's/^  *//' -e 's/ .*//' temp > crap
   cp crap energies.minus

   cp energies.plus energies.plus.save
   cat energies.minus >> energies.plus
   mv energies.plus energies.path
   mv energies.plus.save energies.plus

   set nlines=`wc -l points.save.minus | sed -e 's/[A-z]//g' -e 's/\.//g'`
   @ nlines -=$natoms
   cp points.save.plus points.save.plus.save
#
#  WARNING the tail command will fail if nlines is too large, epsecially
#  on stupid computers!
#
#   tail -$nlines points.save.minus >> points.save.plus
   sed -e "1,$natoms d" points.save.minus >> points.save.plus
   mv points.save.plus points.path
   mv points.save.plus.save points.save.plus

   echo $natoms > natoms

   anal.path.split < points.path > anal.path.out

#  Must have the right system name for CPMD in odata. Or not bother...

#  echo STEPS  0 > odata
#  sed -e '/STEPS/d' odata.$file >> odata
#  OPTIM.2.0 > temp
#  grep group temp | sed -e '/belongs/d' -e '/RMS/d' > group.ts
#  echo STEPS  0 > odata
#  sed -e '/STEPS/d' odata.plus >> odata
#  OPTIM.2.0 > temp
#  grep group temp | sed -e '/belongs/d' -e '/RMS/d' > group.plus
#  echo STEPS  0 > odata
#  sed -e '/STEPS/d' odata.minus >> odata
#  OPTIM.2.0 > temp
#  grep group temp | sed -e '/belongs/d' -e '/RMS/d' > group.minus

   echo C1 > group.ts
   echo C1 > group.plus
   echo C1 > group.minus

   summarise > summary

rm vector.dump units points.$file output.$file odata.$file points.final output odata.new points.save.minus \
   energies.plus energies.minus crap points.save.plus natoms group.* odata points ARCHIVE temp

   cd ../..

end
