! To compile:
! f2py -c --fcompiler='gnu95' -m read_minimum_atomistic read_minimum_atomistic.f90

SUBROUTINE READ_MINIMUM_ATOMISTIC(FILENAME, ID, NMOL, NSITES, COORDS)
! Subroutine to read a PATHSAMPLE landscape database for a rigid-body molecular system, and extract cartesian coordinates
! for every atom (rigid-body site) of a particular minimum.
! This subroutine will also be appropriate for reading cartesian coordinates of atomic systems (simply use NSITES=1).

! Designed for compilation as a python shared object using the f2py program, allowing python programs to read
! databases in PATHSAMPLE format.

    IMPLICIT NONE

    CHARACTER(LEN=100), INTENT(IN) :: FILENAME  ! The path to the points.min file
    INTEGER, INTENT(IN) :: ID                   ! The ID of the minimum to be extracted (its position in points.min)
    INTEGER, INTENT(IN) :: NSITES               ! The number of sites per molecule (1 for an atomistic system)
    INTEGER, INTENT(IN) :: NMOL                 ! The number of molecules in the system
    DOUBLE PRECISION, INTENT(OUT), DIMENSION(NMOL*NSITES,3) :: COORDS   ! Output: the coordinates of the minimum

    DOUBLE PRECISION, DIMENSION(3*NMOL*NSITES) :: LOCALPOINTS  ! Temporary array to read in the coordinates
    INTEGER :: J1      ! Loop counter
    INTEGER :: NATOMS  ! The number of atoms in the system (i.e. the number of rigid-body sites)
    LOGICAL :: DEBUG   ! Logical variable to enable debug printing. Hard-coded to FALSE by default.

    DEBUG=.FALSE.

    NATOMS = NMOL*NSITES

    ! Read the file (Fortran unformatted file. Note, be careful with the endianness if using with a different configuration
    ! and/or compilers. Test the output carefully using the DEBUG flag before using this subroutine for a serious job!
    OPEN(UNIT=12,FILE=TRIM(ADJUSTL(FILENAME)),ACCESS='DIRECT',FORM='UNFORMATTED',STATUS='UNKNOWN',RECL=8*3*NATOMS)
    IF (DEBUG) PRINT '(A,I10)', 'read_minimum_atomistic> Minimum ',ID
    READ(12,REC=ID) (LOCALPOINTS(J1),J1=1,3*NATOMS)
    CLOSE(12)

    DO J1=1,NATOMS
       COORDS(J1,:)=LOCALPOINTS(3*J1-2:3*J1)
    ENDDO

    RETURN
END SUBROUTINE READ_MINIMUM_ATOMISTIC
