#!/usr/bin/env python

from pylab import *
import argparse
import os

parser=argparse.ArgumentParser(description="tip4p pdb -> xyz")
parser.add_argument("-i","--inputs",default=None,help="input file (pdb). default is all in current directory.")
parser.add_argument("-o","--outputs",default=None,help="output file (xyz).")
parser.add_argument("-n","--ntip",type=int,default=3,help="the 'n' in tipnp (3,4)")
args=parser.parse_args()

if not args.inputs:
	args.inputs=[x for x in os.listdir('.') if x[-4:]==".pdb"]
#	print ("working on {}\n"*len(args.inputs)).format(*args.inputs)
else:
	args.inputs=[args.inputs]

if not args.outputs:
	args.outputs=[x.replace(".pdb",".xyz") for x in args.inputs]
#	print ("making {}\n"*len(args.outputs)).format(*args.outputs)
else:
	args.outputs=[args.outputs]

for i in xrange(len(args.inputs)):
	data=genfromtxt(args.inputs[i],usecols=(5,6,7))
	data=reshape(data,[-1,args.ntip,3])
	fout=open(args.outputs[i],'w')
	fout.write("{}\n\n".format(data.shape[0]*3))
	for j in data:
		fout.write("O\t{:10.5f}{:10.5f}{:10.5f}\n".format(*j[0]))
		fout.write("H\t{:10.5f}{:10.5f}{:10.5f}\n".format(*j[1]))
		fout.write("H\t{:10.5f}{:10.5f}{:10.5f}\n".format(*j[2]))
