!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! program to convert water coordinates from cartesians in xyz format to
!! angle-axis in GMIN format (centres of mass followed by orientations.)
!!
!! usage: tiptorigid.exe < xyz > aa
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
PROGRAM TIPTORIGID
IMPLICIT NONE
INTEGER                       :: NATOMS, STAT, I, I2
DOUBLE PRECISION              :: SITE(3,3)
DOUBLE PRECISION, ALLOCATABLE :: COORDS(:)

CALL REFERENCE(SITE)

CALL READNATOMS(NATOMS)
ALLOCATE(COORDS(2*NATOMS))

DO
   CALL READFRAME(NATOMS,COORDS,SITE,STAT)
   IF(STAT.NE.0) EXIT
   WRITE(6,'(3F20.10)')COORDS(:)
ENDDO

END PROGRAM TIPTORIGID

!------------------------------------------------------------------------------!

SUBROUTINE REFERENCE(SITE)
IMPLICIT NONE
DOUBLE PRECISION :: PI,ROH,ROM,THETA
DOUBLE PRECISION :: COM(3),MASSES(3),SITE(3,3)
INTEGER          :: I

PI    = 4.D0*DATAN(1.D0)
ROH   = 0.9572D0
ROM   = 0.15D0
THETA = 104.52D0
THETA = PI*THETA/180.D0
MASSES=(/16.D0,1.D0,1.D0/)

SITE(1,1) = 0.D0
SITE(2,1) = 0.D0
SITE(3,1) = 0.D0

SITE(1,2) = 0.D0
SITE(2,2) = SIN(0.5D0*THETA)*ROH
SITE(3,2) = COS(0.5D0*THETA)*ROH

SITE(1,3) = 0.D0
SITE(2,3) = -SIN(0.5D0*THETA)*ROH
SITE(3,3) = COS(0.5D0*THETA)*ROH

COM(:) = 0.D0
DO I = 1,3
   COM(:) = COM(:) + MASSES(I)*SITE(:,I)
ENDDO
COM(:) = COM(:)/18.D0

DO I = 1,3
   SITE(:,I) = SITE(:,I) - COM(:)
ENDDO

RETURN

END SUBROUTINE REFERENCE

!------------------------------------------------------------------------------!

SUBROUTINE READNATOMS(NATOMS)
IMPLICIT NONE
INTEGER :: NATOMS

READ(5,*)NATOMS
REWIND(5)
RETURN

END SUBROUTINE READNATOMS

!------------------------------------------------------------------------------!

SUBROUTINE READFRAME(NATOMS,COORDS,PI,STAT)
USE ROTATIONS
IMPLICIT NONE
CHARACTER(LEN=6) :: DUMMY
INTEGER          :: NATOMS, STAT, I, I2, I3
DOUBLE PRECISION :: COORDS(2*NATOMS), COM(3), MASSES(3), PT(3,3), PI(3,3)

MASSES=(/16.D0,1.D0,1.D0/)
READ(5,*,IOSTAT=STAT)
IF(STAT.NE.0) RETURN
READ(5,*,IOSTAT=STAT)
DO I=1,NATOMS/3
   !read water molecule
   COM(:)=0.D0
   DO I2=1,3
      READ(5,*,IOSTAT=STAT)DUMMY,PT(:,I2)
      COM(:)=COM(:)+MASSES(I2)*PT(:,I2)
   ENDDO
   COM(:)=COM(:)/18.D0
   COORDS(3*I-2:3*I)=COM(:)
   !zero COM
   DO I2=1,3
      PT(:,I2)=PT(:,I2)-COM(:)
   ENDDO
   !convert to aa
   COORDS(3*I+NATOMS-2:3*I+NATOMS)=ROT_GET_ORIENTATION_AA(PT, PI)
ENDDO

RETURN

END SUBROUTINE READFRAME

!------------------------------------------------------------------------------!
