!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! program to convert water coordinates from angle-axis in GMIN format
!! (centres of mass followed by orientations) to cartesians in xyz format.
!!
!! usage: rigidtotip.exe < aa > xyz
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
PROGRAM RIGIDTOTIP
IMPLICIT NONE
INTEGER                       :: NATOMS, I, I2
DOUBLE PRECISION              :: SITE(3,3)
DOUBLE PRECISION, ALLOCATABLE :: COORDS(:)

CALL REFERENCE(SITE)

CALL READNATOMS(NATOMS)
NATOMS=NATOMS/2
WRITE(6,*)3*NATOMS
WRITE(6,*)

ALLOCATE(COORDS(9*NATOMS))
CALL READFRAME(NATOMS,COORDS,SITE)

END PROGRAM RIGIDTOTIP

!------------------------------------------------------------------------------!

SUBROUTINE REFERENCE(SITE)
IMPLICIT NONE
DOUBLE PRECISION :: PI,ROH,ROM,THETA
DOUBLE PRECISION :: COM(3),MASSES(3),SITE(3,3)
INTEGER          :: I

PI    = 4.D0*DATAN(1.D0)
ROH   = 0.9572D0
ROM   = 0.15D0
THETA = 104.52D0
THETA = PI*THETA/180.D0
MASSES=(/16.D0,1.D0,1.D0/)

SITE(1,1) = 0.D0
SITE(1,2) = 0.D0
SITE(1,3) = 0.D0

SITE(2,1) = 0.D0
SITE(2,2) = SIN(0.5D0*THETA)*ROH
SITE(2,3) = COS(0.5D0*THETA)*ROH

SITE(3,1) = 0.D0
SITE(3,2) = -SIN(0.5D0*THETA)*ROH
SITE(3,3) = COS(0.5D0*THETA)*ROH

COM(:) = 0.D0
DO I = 1,3
   COM(:) = COM(:) + MASSES(I)*SITE(I,:)
ENDDO
COM(:) = COM(:)/18.D0

DO I = 1,3
   SITE(I,:) = SITE(I,:) - COM(:)
ENDDO

RETURN

END SUBROUTINE REFERENCE

!------------------------------------------------------------------------------!

SUBROUTINE READNATOMS(NATOMS)
IMPLICIT NONE
INTEGER :: NATOMS, STAT

NATOMS=0

DO
   READ(5,*,IOSTAT=STAT)
   IF(STAT.NE.0) RETURN
   NATOMS=NATOMS+1
ENDDO

REWIND(5)

RETURN

END SUBROUTINE READNATOMS

!------------------------------------------------------------------------------!

SUBROUTINE READFRAME(NATOMS,COORDS,SITE)
USE ROTATIONS
IMPLICIT NONE
INTEGER          :: NATOMS, I, I2, I3, I4, J
DOUBLE PRECISION :: COORDS(9*NATOMS), RBCOORDS(6*NATOMS), P(3), SITE(3,3), RMAT(3,3), COM(3)

REWIND(5)

DO I=1,2*NATOMS
   I2=3*I
   READ(5,*)RBCOORDS(I2-2:I2)
ENDDO

DO I=1,NATOMS
   I2=3*I
   I3=3*(I+NATOMS)
   I4=9*I
   COM(:)=RBCOORDS(I2-2:I2)
   P(:)=RBCOORDS(I3-2:I3)
   CALL ROTMAT(P,RMAT)
   WRITE(6,'(A4,3F20.10)')'O',MATMUL(RMAT,SITE(1,:))+COM(:)
   WRITE(6,'(A4,3F20.10)')'H',MATMUL(RMAT,SITE(2,:))+COM(:)
   WRITE(6,'(A4,3F20.10)')'H',MATMUL(RMAT,SITE(3,:))+COM(:)
ENDDO

RETURN

END SUBROUTINE READFRAME

!------------------------------------------------------------------------------!

SUBROUTINE ROTMAT(P,RMAT)
IMPLICIT NONE
DOUBLE PRECISION  :: RMAT(3,3),P(3),THETA,COST,SINT,A,B,C

RMAT=0.D0
THETA=SQRT(DOT_PRODUCT(P,P))
P=P/THETA

SINT=SIN(THETA)
COST=1-COS(THETA)
A=P(1)
B=P(2)
C=P(3)
RMAT(1,1)=   1.D0 + COST*(A**2-1.D0)
RMAT(1,2)=-C*SINT + COST*(A*B)
RMAT(1,3)= B*SINT + COST*(A*C)
RMAT(2,1)= C*SINT + COST*(B*A)
RMAT(2,2)=   1.D0 + COST*(B**2-1.D0)
RMAT(2,3)=-A*SINT + COST*(B*C)
RMAT(3,1)=-B*SINT + COST*(C*A)
RMAT(3,2)= A*SINT + COST*(C*B)
RMAT(3,3)=   1.D0 + COST*(C**2-1.D0)

END SUBROUTINE ROTMAT

!------------------------------------------------------------------------------!
