#!/usr/bin/env python

from pylab import *
import argparse
import os

parser=argparse.ArgumentParser(description="tip4p xyz -> pdb")
parser.add_argument("-i","--inputs",default=None,help="input file (xyz). default is all in current directory.")
parser.add_argument("-o","--outputs",default=None,help="output file (pdb).")
parser.add_argument("-n","--ntip",type=int,default=3,help="the 'n' in tipnp (3,4)")
args=parser.parse_args()

if not args.inputs:
	args.inputs=[x for x in os.listdir('.') if x[-4:]==".xyz"]
#	print ("working on {}\n"*len(args.inputs)).format(*args.inputs)
else:
	args.inputs=[args.inputs]

if not args.outputs:
	args.outputs=[x.replace(".xyz",".pdb") for x in args.inputs]
#	print ("making {}\n"*len(args.outputs)).format(*args.outputs)
else:	args.outputs=[args.outputs]

for i in xrange(len(args.inputs)):
	data=genfromtxt(args.inputs[i],usecols=(1,2,3),skip_header=2)
	data=reshape(data,[-1,3,3])
	fout=open(args.outputs[i],'w')
	data2=zeros([data.shape[0],4,3])
	data2[:,:3,:]=data
	n=0
	for j in data2:
		n+=1
		fout.write("ATOM {:6}    O TP{} {:5}     {:7.3f} {:7.3f} {:7.3f}\n".format(n*args.ntip-3,args.ntip,n,*j[0,:]))
		fout.write("ATOM {:6}   H1 TP{} {:5}     {:7.3f} {:7.3f} {:7.3f}\n".format(n*args.ntip-2,args.ntip,n,*j[1,:]))
		fout.write("ATOM {:6}   H2 TP{} {:5}     {:7.3f} {:7.3f} {:7.3f}\n".format(n*args.ntip-1,args.ntip,n,*j[2,:]))
		if args.ntip==4:
			OH1=j[1,:]-j[0,:]
			OH2=j[2,:]-j[0,:]
			OM=(OH1+OH2)/linalg.norm(OH1+OH2)*0.15
			j[3,:]=j[0,:]+OM
			fout.write("ATOM {:6}  EPW TP{} {:5}     {:7.3f} {:7.3f} {:7.3f}\n".format(n*args.ntip-0,args.ntip,n,*j[3,:]))
	fout.close()
