#!/bin/bash
# Script to produce a hydrogen-bond matrix for the structure provided using AMBER ptraj
# Chris Whittleston April 2012 (csw34@cam.ac.uk)

# Arguements:
# $1 = the AMBER topology file (e.g. coords.prmtop)
# $2 = the AMBER coordinate file (e.g. coords.inpcrd, min1.rst, quench1.pdb etc. Use .rst if possible.)
# $3 = ptraj donor/acceptor list
# $4 = file containing residues of interest (1 per line)

# Check for the correct number of arguements
expected_args=4
if [ $# -ne $expected_args ]
then
   echo "Missing arguements! :("
   echo "./hbond_matrix.sh <topology file> <rst/pdb file> <ptraj donor/acceptors> <residues of interest>"
   exit
fi

# Hydrogen-bond cutoffs (ptraj defaults are 3.00 and 120.00)
# Note that it seems only the angle cutoff changes when altering these values :(
distance_cutoff=3.00
angle_cutoff=120.00

# Construct full ptraj input file
echo "trajin ${2}" > hbond.in.top
echo "hbond out hbond.out dist ${distance_cutoff} angle ${angle_cutoff}" >> hbond.in.bottom 
cat hbond.in.top $3 hbond.in.bottom > hbond.in

# Run ptraj
ptraj $1 < hbond.in > ptraj.tmp

# Calculate matrix elements
# OUTER RESIDUE LOOP
for res1 in `cat $4`
do
# INNER RESIDUE LOOP
   for res2 in `cat $4`
   do
# If not on the diagonal (self)
      if [ "${res1}" != "${res2}" ]; then
         nhbonds=`grep ":${res1}@" hbond.out | grep ":${res2}@" | wc |awk '{print $1}'`
         echo $nhbonds >> ${res1}.tmp
      else
# If on the diagonal, just echo 0
         echo "0" >> ${res1}.tmp
      fi
   done
done

# Construct the paste command to assemble matrix
command="paste "
for res in `cat $4`
do
   command="${command} ${res}.tmp "
done

# Execute paste command
$command > mat.tmp

# Nicely format the output
column -t mat.tmp 

# Remove temporary files 
rm hbond.out hbond.in hbond.in.top hbond.in.bottom *.tmp
