#!/bin/csh
set radius=3.0
set natoms=19
# would need to change the grep and/or output file for GMIN
set exec=~/GMIN/GMIN
# set exec=~/bin/GMIN
set directory=$1
set seed=$2

mkdir $directory
cd $directory
cp ../data.template data
rm hits >& /dev/null
set count=1

echo
echo Running GMIN for 19 Gupta atoms from 100 random starting geometries
echo Random number seeds start from $2
echo

while ($count <= 100)
   echo $natoms $radius -$seed > randata
   rancoords # >& /dev/null
   cp newcoords coords
   echo count $count
   $exec >& $directory.output.$natoms.$count
   echo `grep hit output | head -1 | sed -e 's/[a-zA-Z]//g' -e 's/[a-zA-Z]//g' -e 's/\.//' -e 's/>//'` \
        `grep time= output | tail -1 | sed 's/.*time=//'` >> hits
   cp coords coords.$count
   @ count +=1
   @ seed +=1 
end

gminconv2 < hits > temp ; head -1 temp > pdf
echo
echo Mean and standard deviation for global minimum first encounter time
echo
cat pdf
