#!/bin/bash
radius=3.0
natoms=98
numrand=100
exec=/home/wales/GMIN.gfortran/GMIN
directory=$1
seed=${2:-3} # default value is 1

mkdir -p $directory
cd $directory
cp ../data.$1 data
rm hits >& /dev/null
count=1

echo
echo Running GMIN for $natoms LJ atoms from $numrand random starting geometries 
echo Random number seeds start from $seed
echo

while [ $count -le $numrand ] ; do
   echo $natoms $radius -$seed > randata
   rancoords # >& /dev/null
   cp newcoords coords
   echo count $count
   $exec >& output
   echo `grep hit output | head -1 | sed -e 's/[a-zA-Z]//g' -e 's/[a-zA-Z]//g' -e 's/\.//' -e 's/>//'` \
        `grep time= output | tail -1 | sed 's/.*time=//'` >> hits
   cp coords coords.$count
   ### DEBUG ### DJW
   cp output output.$count
   ### DEBUG ### DJW
   ((count++))
   ((seed++))
done

gminconv2 < hits > temp ; head -1 temp > pdf
echo
echo Mean and standard deviation for global minimum first encounter time
echo
cat pdf

